//
//  SPBoxView-IBIntegration.m
//  SamplePlugIn
//
//  Created by Kai on 12.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <InterfaceBuilderKit/InterfaceBuilderKit.h>
#import "NSShadow-IBIntegration.h"


//-------------------------------------------------------------------------------------------
@implementation NSShadow (IBIntegration)
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
+ (NSSet*) keyPathsForValuesAffectingAppearance {
	// Create a combined key which can be observed to catch changes affecting the drawing
	// of the shadow.
	return [NSSet setWithObjects:@"shadowOffset", @"shadowBlurRadius", @"shadowColor", nil];
}

#pragma mark Separate Accessor for shadowOffset ---------------------------------------------
// Note: I first tried to implement the shadowOffset separation in NSShadow_IBInspector, but
// for unknown reason the bindings against the inspector did not really work (no update of
// the UI). And doing it here is easier anyway.
//-------------------------------------------------------------------------------------------
- (CGFloat) hOffset {
	return [self shadowOffset].width;
}

//-------------------------------------------------------------------------------------------
- (void) setHOffset:(CGFloat)value {
	NSSize offset = [self shadowOffset];
	offset.width = value;
	[self setShadowOffset:offset];
}

//-------------------------------------------------------------------------------------------
- (CGFloat) vOffset {
	CGFloat value = [self shadowOffset].height;
	// Flipped vertical value is more what users expect.
	if (value != 0.0)		// without this test, UI would show "-0"
		value = -value;
	return value;
//	return [NSNumber numberWithDouble: -[self shadowOffset].height];
}

//-------------------------------------------------------------------------------------------
- (void) setVOffset:(CGFloat)value {
	NSSize offset = [self shadowOffset];
	// Flipped vertical value is more what users expect.
	offset.height = -value;
	[self setShadowOffset:offset];
}

#pragma mark IBObjectIntegration ------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (void) ibPopulateKeyPaths:(NSMutableDictionary*)keyPaths {
	[super ibPopulateKeyPaths:keyPaths];
	
	// Remove the comments and replace "MyFirstProperty" and "MySecondProperty" 
	// in the following line with a list of your view's KVC-compliant properties.
	[[keyPaths objectForKey:IBAttributeKeyPaths] addObjectsFromArray:
					[NSArray arrayWithObjects:@"shadowOffset",
													  @"shadowBlurRadius",
													  @"shadowColor",
													  nil]];
}

//-------------------------------------------------------------------------------------------
- (void) ibPopulateAttributeInspectorClasses:(NSMutableArray*)classes {
	[super ibPopulateAttributeInspectorClasses:classes];
	[classes addObject:[NSShadow_IBInspector class]];
}

//-------------------------------------------------------------------------------------------
// Although never used, the accessor for "appearance" must be present to make observation for
// it work.
- (id) appearance { return nil; }

//-------------------------------------------------------------------------------------------
@end


//-------------------------------------------------------------------------------------------
@implementation NSShadow_IBInspector
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
- (NSString*) viewNibName {
	return @"NSShadowIBInspector";
}

//-------------------------------------------------------------------------------------------
- (NSString*) label {
	return @"Shadow";
}

@end
